<?php
require "../functions/getUserById.php";

function getPolicy()
{
   $sock = Login();
   checkActionAccess($sock, "read");

   $arr = ParamGet($sock, "security");
   $arr = $arr->security->user;
   $arr = array_sort_by_accesslevel($arr);

   $json = [];

   foreach ($arr as $user) {
      foreach ($user as $key => $value) {
         if ($key == "deny") {
            array_push($json, $user->deny);
         }
      }
   }

   $users = $arr;
   foreach ($users as $key => $value) {
      unset($value->password);
      unset($value->txlimit);
      unset($value->enabled);

      $value->login = ConvertNative2UTF($value->login);
      $value->login = str_replace("?", "И", $value->login);
   }
   foreach ($users as $user) {
      if (isset($user->accesslevel) && $user->accesslevel != 1) {
         $user->accesslevel = $user->accesslevel / 10;
      }

      if (isset($user->deny) && isset($user->deny->misc)) {
         if (!isset($user->deny->misc->read)) {
            $user->deny->misc->read = 1;
         }

         if (!isset($user->deny->misc->write)) {
            $user->deny->misc->write = 1;
            $user->deny->misc->j_read = 1;
            $user->deny->misc->j_play = 1;
         }

         if (!isset($user->deny->misc->play)) {
            $user->deny->misc->play = 1;
         }

         if (!isset($user->deny->misc->ptz)) {
            $user->deny->misc->ptz = 1;
         }

         if ($user->deny->misc->play == 8) {
            $user->deny->misc->play = 1;
            $user->deny->misc->j_play = 0;
         } elseif ($user->deny->misc->play == 24) {
            $user->deny->misc->play = 0;
            $user->deny->misc->j_play = 0;
         }

         if ($user->deny->misc->ptz == 16) {
            $user->deny->misc->ptz = 0;
         }

         if ($user->deny->misc->write == 8) {
            $user->deny->misc->write = 1;
         } elseif ($user->deny->misc->write == 16) {
            $user->deny->misc->write = 0;
            $user->deny->misc->j_read = 1;
         } elseif ($user->deny->misc->write == 24) {
            $user->deny->misc->write = 0;
            $user->deny->misc->j_read = 0;
            $user->deny->misc->j_play = 0;
         }

         if ($user->deny->misc->read == 8) {
            $user->deny->misc->read = 1;
            $user->deny->misc->j_read = 0;
         } elseif ($user->deny->misc->read == 16) {
            $user->deny->misc->read = 0;
            $user->deny->misc->j_read = 1;
         } elseif ($user->deny->misc->read == 24) {
            $user->deny->misc->read = 0;
            $user->deny->misc->j_read = 0;
         }
      }

      if (isset($user->deny)) {
         if (isset($user->deny->camera)) {
            $user->deny->camera = sort_nested_arrays($user->deny->camera, ["index" => "desc"]);
            $countCamera = 0;
            foreach ($user->deny->camera[0] as $object) {
               $countCamera += 1;
            }
            if (count($user->deny->camera) == 4 && $countCamera === 1) {
               $convert = $user->deny->camera[0];
               $user->deny->camera[0] = $user->deny->camera[3];
               $user->deny->camera[0]->index = 0;
               $user->deny->camera[3] = $convert;
               $user->deny->camera[3]->index = 3;
            }
         }

         if (isset($user->deny->sound)) {
            $user->deny->sound = sort_nested_arrays($user->deny->sound, ["index" => "desc"]);
            $countSound = 0;
            foreach ($user->deny->sound[0] as $object) {
               $countSound += 1;
            }
            if (count($user->deny->sound) == 4 && $countSound === 1) {
               $convert = $user->deny->sound[0];
               $user->deny->sound[0] = $user->deny->sound[3];
               $user->deny->sound[0]->index = 0;
               $user->deny->sound[3] = $convert;
               $user->deny->sound[3]->index = 3;
            }
         }
      }
   }

   $users = sort_nested_arrays($users, ["login" => "desc"]);

   socket_close($sock);
   return $users;
}
function getUserAccess()
{
   $sock = Login();
   checkActionAccess($sock, "read");
   $arr = ParamGet($sock, "security");
   $arr = $arr->security->user;
   $arr = sort_nested_arrays($arr, ["index" => "desc"]);
   $arr = array_sort_by_accesslevel($arr);

   $json = [];

   foreach ($arr as $user) {
      $lvl = $user->accesslevel != 1 ? $user->accesslevel / 10 : 1;
      array_push($json, ["index" => $user->index, "access" => $lvl]);
   }
   socket_close($sock);
   return $json;
}

function getUserAccessByServer($id, $gettersSecurity)
{
   $user = null;
   $users = $gettersSecurity->security->user;

   $key = array_search($id, array_column($users, "id"));

   if ($key !== false) {
      $user = $users[$key];
   }

   $access = [];

   if (!isset($user->deny) || !isset($user->deny->misc)) {
      $access["read"] = true;
      $access["write"] = true;
      $access["j_read"] = true;
      $access["j_play"] = true;
      $access["play"] = true;
      $access["ptz"] = true;

      return $access;
   }

   if (!isset($user->deny->misc->read)) {
      $access["read"] = true;
   }
   if (!isset($user->deny->misc->write)) {
      $access["write"] = true;
      $access["j_read"] = true;
      $access["j_play"] = true;
   }
   if (!isset($user->deny->misc->play)) {
      $access["play"] = true;
   }
   if (!isset($user->deny->misc->ptz)) {
      $access["ptz"] = true;
   }

   foreach ($user->deny->misc as $key => $value) {
      switch ($key) {
         case "read":
            if ($value == 8) {
               $access["read"] = true;
               $access["j_read"] = false;
               $access["j_play"] = false;
               break;
            }
            if ($value == 16) {
               $access["read"] = false;
               $access["j_read"] = true;
               break;
            }
            if ($value == 24) {
               $access["read"] = false;
               $access["j_read"] = false;
            }
            break;
         case "write":
            if ($value == 8) {
               $access["write"] = true;
               break;
            }
            if ($value == 16) {
               $access["write"] = false;
               $access["j_read"] = true;
               break;
            }
            if ($value == 24) {
               $access["write"] = false;
               $access["j_read"] = false;
               $access["j_play"] = false;
            }
            break;
         case "play":
            if ($value == 8) {
               $access["play"] = true;
               $access["j_play"] = false;
               break;
            }
            if ($value == 16 || $value == 24) {
               $access["play"] = false;
               $access["j_play"] = false;
            }
            break;
         case "ptz":
            if ($value == 16) {
               $access["ptz"] = false;
            }
            break;
         default:
            # code...
            break;
      }
   }
   return $access;
}
